/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.mutable.MutableObject;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.ArmorUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.BlackHoleTalismanExtractRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticAttachRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticRemoveRecipe;
import vazkii.botania.common.crafting.recipe.KeepIvyRecipe;
import vazkii.botania.common.crafting.recipe.LaputaShardUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.LensDyeingRecipe;
import vazkii.botania.common.crafting.recipe.ManaGunClipRecipe;
import vazkii.botania.common.crafting.recipe.ManaGunLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaGunRemoveLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.MergeVialRecipe;
import vazkii.botania.common.crafting.recipe.PhantomInkRecipe;
import vazkii.botania.common.crafting.recipe.ShapelessManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.SpellClothRecipe;
import vazkii.botania.common.crafting.recipe.SplitLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraPickTippingRecipe;
import vazkii.botania.common.crafting.recipe.TwigWandRecipe;
import vazkii.botania.common.crafting.recipe.WaterBottleMatchingRecipe;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;
import vazkii.botania.data.recipes.GogAlternationResult;
import vazkii.botania.data.recipes.NbtOutputResult;
import vazkii.botania.data.recipes.WrapperResult;
import vazkii.botania.mixin.AccessorIngredient;
import vazkii.botania.mixin.AccessorRecipeProvider;

public class RecipeProvider
extends BotaniaRecipeProvider {
    public RecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerRecipes(Consumer<FinishedRecipe> consumer) {
        this.specialRecipe(consumer, AncientWillRecipe.SERIALIZER);
        this.specialRecipe(consumer, BlackHoleTalismanExtractRecipe.SERIALIZER);
        this.specialRecipe(consumer, CompositeLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, CosmeticAttachRecipe.SERIALIZER);
        this.specialRecipe(consumer, CosmeticRemoveRecipe.SERIALIZER);
        this.specialRecipe(consumer, KeepIvyRecipe.SERIALIZER);
        this.specialRecipe(consumer, LaputaShardUpgradeRecipe.SERIALIZER);
        this.specialRecipe(consumer, LensDyeingRecipe.SERIALIZER);
        this.specialRecipe(consumer, ManaGunClipRecipe.SERIALIZER);
        this.specialRecipe(consumer, ManaGunLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, ManaGunRemoveLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, MergeVialRecipe.SERIALIZER);
        this.specialRecipe(consumer, PhantomInkRecipe.SERIALIZER);
        this.specialRecipe(consumer, SpellClothRecipe.SERIALIZER);
        this.specialRecipe(consumer, SplitLensRecipe.SERIALIZER);
        this.specialRecipe(consumer, TerraPickTippingRecipe.SERIALIZER);
        this.registerMain(consumer);
        this.registerMisc(consumer);
        this.registerTools(consumer);
        this.registerTrinkets(consumer);
        this.registerLenses(consumer);
        this.registerCorporeaAndRedString(consumer);
        this.registerFloatingFlowers(consumer);
        this.registerConversions(consumer);
        this.registerDecor(consumer);
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return AccessorRecipeProvider.botania_condition(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance conditionsFromItems(ItemLike ... items) {
        ItemPredicate[] preds = new ItemPredicate[items.length];
        for (int i = 0; i < items.length; ++i) {
            preds[i] = ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{items[i]}).m_45077_();
        }
        return AccessorRecipeProvider.botania_condition(preds);
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> tag) {
        return AccessorRecipeProvider.botania_condition(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    protected ResourceLocation prefix(String path) {
        return ResourceLocationHelper.prefix(path);
    }

    private void registerMain(Consumer<FinishedRecipe> consumer) {
        InventoryChangeTrigger.TriggerInstance hasAnyDye = RecipeProvider.conditionsFromItems((ItemLike[])Arrays.stream(DyeColor.values()).map(DyeItem::m_41082_).toArray(ItemLike[]::new));
        MutableObject base = new MutableObject();
        MutableObject gog = new MutableObject();
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaSpreader).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126130_("WWW").m_126130_("GP ").m_126130_("WWW").m_142409_("botania:spreader").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.LIVINGWOOD_LOGS)).m_176498_(arg_0 -> ((MutableObject)base).setValue(arg_0));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaSpreader).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_("WWW").m_126130_("WP ").m_126130_("WWW").m_142409_("botania:spreader").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.LIVINGWOOD_LOGS)).m_176498_(arg_0 -> ((MutableObject)gog).setValue(arg_0));
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.redstoneSpreader).m_126209_((ItemLike)ModBlocks.manaSpreader).m_126209_((ItemLike)Items.f_42451_).m_142409_("botania:spreader").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.manaSpreader)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.elvenSpreader).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_206416_(Character.valueOf('W'), ModTags.Items.DREAMWOOD_LOGS).m_126130_("WWW").m_126130_("EP ").m_126130_("WWW").m_142409_("botania:spreader").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.gaiaSpreader).m_126209_((ItemLike)ModBlocks.elvenSpreader).m_206419_(ModTags.Items.GEMS_DRAGONSTONE).m_126209_((ItemLike)ModItems.lifeEssence).m_142409_("botania:spreader").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaPool).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrock).m_126130_("R R").m_126130_("RRR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.dilutedPool).m_126127_(Character.valueOf('R'), (ItemLike)ModFluffBlocks.livingrockSlab).m_126130_("R R").m_126130_("RRR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.fabulousPool).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.shimmerrock).m_126130_("R R").m_126130_("RRR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.shimmerrock)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.rainbowRod)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.fabulousPool).m_126127_(Character.valueOf('P'), (ItemLike)ModBlocks.manaPool).m_126127_(Character.valueOf('B'), (ItemLike)ModBlocks.bifrostPerm).m_126130_("BPB").m_126130_("BBB").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.bifrostPerm)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.rainbowRod)).m_142700_(consumer, this.prefix(Registry.f_122827_.m_7981_((Object)ModBlocks.fabulousPool.m_5456_()).m_135815_() + "_upgrade"));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.runeAltar).m_126124_(Character.valueOf('P'), AccessorIngredient.callFromValues(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)ModItems.manaPearl)), new Ingredient.TagValue(ModTags.Items.GEMS_MANA_DIAMOND)))).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126130_("SSS").m_126130_("SPS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaPylon).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_(" G ").m_126130_("MDM").m_126130_(" G ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.naturaPylon).m_126127_(Character.valueOf('P'), (ItemLike)ModBlocks.manaPylon).m_206416_(Character.valueOf('T'), ModTags.Items.NUGGETS_TERRASTEEL).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126130_(" T ").m_126130_("TPT").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.manaPylon)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.gaiaPylon).m_126127_(Character.valueOf('P'), (ItemLike)ModBlocks.manaPylon).m_126127_(Character.valueOf('D'), (ItemLike)ModItems.pixieDust).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_(" D ").m_126130_("EPE").m_126130_(" D ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.distributor).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrock).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("RRR").m_126130_("S S").m_126130_("RRR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaVoid).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("SSS").m_126130_("O O").m_126130_("SSS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaDetector).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('T'), (ItemLike)Blocks.f_50716_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126130_("RSR").m_126130_("STS").m_126130_("RSR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Blocks.f_50716_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaDetector).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42351_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126130_("RSR").m_126130_("SCS").m_126130_("RSR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42351_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock)).m_176500_(consumer, "botania:mana_detector_old");
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.turntable).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_41862_).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_("WWW").m_126130_("WPW").m_126130_("WWW").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.LIVINGWOOD_LOGS)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41862_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.tinyPlanet).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.tinyPlanet).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126130_("SSS").m_126130_("SPS").m_126130_("SSS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.tinyPlanet)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.alchemyCatalyst).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42543_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126130_("SGS").m_126130_("BPB").m_126130_("SGS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42543_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.openCrate).m_126127_(Character.valueOf('W'), (ItemLike)ModBlocks.livingwoodPlanks).m_126130_("WWW").m_126130_("W W").m_126130_("W W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingwoodPlanks)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.craftCrate).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41960_).m_126127_(Character.valueOf('W'), (ItemLike)ModBlocks.dreamwoodPlanks).m_126130_("WCW").m_126130_("W W").m_126130_("W W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.dreamwoodPlanks)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.forestEye).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("MSM").m_126130_("SES").m_126130_("MSM").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.wildDrum).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('H'), (ItemLike)ModItems.grassHorn).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("WLW").m_126130_("WHW").m_126130_("WLW").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassHorn)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.gatheringDrum).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_206416_(Character.valueOf('W'), ModTags.Items.DREAMWOOD_LOGS).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("WLW").m_126130_("WEW").m_126130_("WLW").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.canopyDrum).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('H'), (ItemLike)ModItems.leavesHorn).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("WLW").m_126130_("WHW").m_126130_("WLW").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.leavesHorn)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModBlocks.abstrusePlatform, (int)2).m_206416_(Character.valueOf('0'), ModTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('3'), (ItemLike)ModBlocks.livingwoodFramed).m_126127_(Character.valueOf('4'), (ItemLike)ModBlocks.livingwoodPatternFramed).m_126130_("343").m_126130_("0P0").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModBlocks.spectralPlatform, (int)2).m_206416_(Character.valueOf('0'), ModTags.Items.DREAMWOOD_LOGS).m_126127_(Character.valueOf('3'), (ItemLike)ModBlocks.dreamwoodFramed).m_126127_(Character.valueOf('4'), (ItemLike)ModBlocks.dreamwoodPatternFramed).m_126127_(Character.valueOf('D'), (ItemLike)ModItems.pixieDust).m_126130_("343").m_126130_("0D0").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.alfPortal).m_206416_(Character.valueOf('T'), ModTags.Items.NUGGETS_TERRASTEEL).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_("WTW").m_126130_("WTW").m_126130_("WTW").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.conjurationCatalyst).m_126127_(Character.valueOf('P'), (ItemLike)ModBlocks.alchemyCatalyst).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.pixieDust).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_206416_(Character.valueOf('G'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("SBS").m_126130_("GPG").m_126130_("SGS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.spawnerClaw).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42193_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.enderAirBottle).m_206416_(Character.valueOf('M'), ModTags.Items.BLOCKS_MANASTEEL).m_126130_("BSB").m_126130_("PMP").m_126130_("PEP").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.enderAirBottle)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.enderEye).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("RER").m_126130_("EOE").m_126130_("RER").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42545_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.starfield).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.pixieDust).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("EPE").m_126130_("EOE").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.rfGenerator).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("SRS").m_126130_("RMR").m_126130_("SRS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42153_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.brewery).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeMana).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrock).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42543_).m_206416_(Character.valueOf('M'), ModTags.Items.BLOCKS_MANASTEEL).m_126130_("RSR").m_126130_("RAR").m_126130_("RMR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeMana)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42543_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.terraPlate).m_126127_(Character.valueOf('0'), (ItemLike)ModItems.runeWater).m_126127_(Character.valueOf('1'), (ItemLike)ModItems.runeFire).m_126127_(Character.valueOf('2'), (ItemLike)ModItems.runeEarth).m_126127_(Character.valueOf('3'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('8'), (ItemLike)ModItems.runeMana).m_126127_(Character.valueOf('L'), (ItemLike)Blocks.f_50060_).m_206416_(Character.valueOf('M'), ModTags.Items.BLOCKS_MANASTEEL).m_126130_("LLL").m_126130_("0M1").m_126130_("283").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.RUNES)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.prism).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.spectralPlatform).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_41904_).m_126130_("GPG").m_126130_("GSG").m_126130_("GPG").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42696_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.spectralPlatform)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.pump).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("SSS").m_126130_("IBI").m_126130_("SSS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.incensePlate).m_126127_(Character.valueOf('S'), (ItemLike)ModFluffBlocks.livingwoodSlab).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_("WSS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.LIVINGWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.hourglass).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('M'), (ItemLike)ModBlocks.manaGlass).m_126130_("GMG").m_126130_("RSR").m_126130_("GMG").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.manaGlass)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.ghostRail).m_126209_((ItemLike)Items.f_41964_).m_126209_((ItemLike)ModBlocks.spectralPlatform).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41964_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.spectralPlatform)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.sparkChanger).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("ESE").m_126130_("SRS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.felPumpkin).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42046_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42500_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42583_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42403_).m_126130_(" S ").m_126130_("BPF").m_126130_(" G ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42046_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.cocoon).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('C'), (ItemLike)ModItems.manaweaveCloth).m_126127_(Character.valueOf('P'), (ItemLike)ModBlocks.felPumpkin).m_126127_(Character.valueOf('D'), (ItemLike)ModItems.pixieDust).m_126130_("SSS").m_126130_("CPC").m_126130_("SDS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.felPumpkin)).m_176498_(arg_0 -> ((MutableObject)base).setValue(arg_0));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.cocoon).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('P'), (ItemLike)ModBlocks.felPumpkin).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("SSS").m_126130_("SPS").m_126130_("SIS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.felPumpkin)).m_176498_(arg_0 -> ((MutableObject)gog).setValue(arg_0));
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.lightRelayDefault).m_126209_((ItemLike)ModItems.redString).m_206419_(ModTags.Items.GEMS_DRAGONSTONE).m_126209_((ItemLike)Items.f_42525_).m_126209_((ItemLike)Items.f_42525_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.lightRelayDetector).m_126209_((ItemLike)ModBlocks.lightRelayDefault).m_126209_((ItemLike)Items.f_42451_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.lightRelayFork).m_126209_((ItemLike)ModBlocks.lightRelayDefault).m_126209_((ItemLike)Items.f_41978_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.lightRelayToggle).m_126209_((ItemLike)ModBlocks.lightRelayDefault).m_126209_((ItemLike)Items.f_41966_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.lightLauncher).m_206416_(Character.valueOf('D'), ModTags.Items.DREAMWOOD_LOGS).m_126127_(Character.valueOf('L'), (ItemLike)ModBlocks.lightRelayDefault).m_126130_("DDD").m_126130_("DLD").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.lightRelayDefault)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.manaBomb).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41996_).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.lifeEssence).m_206416_(Character.valueOf('L'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_("LTL").m_126130_("TGT").m_126130_("LTL").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.bellows).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('S'), (ItemLike)ModFluffBlocks.livingwoodSlab).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("SSS").m_126130_("RL ").m_126130_("SSS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeAir)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.bifrostPerm).m_126209_((ItemLike)ModItems.rainbowRod).m_126209_((ItemLike)ModBlocks.elfGlass).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.rainbowRod)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)ModBlocks.cellBlock, (int)3).m_126211_((ItemLike)Items.f_41982_, 3).m_126209_((ItemLike)Items.f_42732_).m_126209_((ItemLike)Items.f_42619_).m_126209_((ItemLike)Items.f_42620_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModSubtiles.dandelifeon)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.teruTeruBozu).m_126127_(Character.valueOf('C'), (ItemLike)ModItems.manaweaveCloth).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42206_).m_126130_("C").m_126130_("C").m_126130_("S").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaweaveCloth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.avatar).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_(" W ").m_126130_("WDW").m_126130_("W W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.animatedTorch).m_206416_(Character.valueOf('D'), ModTags.Items.DUSTS_MANA).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41978_).m_126130_("D").m_126130_("T").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41978_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.DUSTS_MANA)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_("W").m_126130_("W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.LIVINGWOOD_LOGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.redstoneRoot).m_126209_((ItemLike)Items.f_42451_).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41865_, Items.f_41864_})).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42451_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.dreamwoodTwig).m_206416_(Character.valueOf('W'), ModTags.Items.DREAMWOOD_LOGS).m_126130_("W").m_126130_("W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.gaiaIngot).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.lifeEssence).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_TERRASTEEL).m_126130_(" S ").m_126130_("SIS").m_126130_(" S ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.manaweaveCloth).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_126130_("SS").m_126130_("SS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaString)).m_176498_(consumer);
        Ingredient dyes = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42535_, Items.f_42536_, Items.f_42537_, Items.f_42538_, Items.f_42539_, Items.f_42540_, Items.f_42489_, Items.f_42490_, Items.f_42491_, Items.f_42492_, Items.f_42493_, Items.f_42494_, Items.f_42495_, Items.f_42496_, Items.f_42497_, Items.f_42498_});
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.fertilizer).m_126209_((ItemLike)Items.f_42499_).m_126186_(dyes, 4).m_142284_("has_item", (CriterionTriggerInstance)hasAnyDye).m_176500_(arg_0 -> ((MutableObject)base).setValue(arg_0), "botania:fertilizer_dye");
        ShapelessRecipeBuilder.m_126191_((ItemLike)ModItems.fertilizer, (int)3).m_126209_((ItemLike)Items.f_42499_).m_126186_(dyes, 4).m_142284_("has_item", (CriterionTriggerInstance)hasAnyDye).m_176500_(arg_0 -> ((MutableObject)gog).setValue(arg_0), "botania:fertilizer_dye");
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.drySeeds).m_126209_((ItemLike)ModItems.grassSeeds).m_126209_((ItemLike)Items.f_41866_).m_142409_("botania:seeds").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.goldenSeeds).m_126209_((ItemLike)ModItems.grassSeeds).m_126209_((ItemLike)Items.f_42405_).m_142409_("botania:seeds").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.vividSeeds).m_126209_((ItemLike)ModItems.grassSeeds).m_126209_((ItemLike)Items.f_42496_).m_142409_("botania:seeds").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.scorchedSeeds).m_126209_((ItemLike)ModItems.grassSeeds).m_126209_((ItemLike)Items.f_42593_).m_142409_("botania:seeds").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.infusedSeeds).m_126209_((ItemLike)ModItems.grassSeeds).m_126209_((ItemLike)Items.f_42695_).m_142409_("botania:seeds").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassSeeds)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.mutatedSeeds).m_126209_((ItemLike)ModItems.grassSeeds).m_126209_((ItemLike)Items.f_42591_).m_142409_("botania:seeds").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassSeeds)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.darkQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126124_(Character.valueOf('C'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_})).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.blazeQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42593_).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.lavenderQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126124_(Character.valueOf('C'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41942_, Items.f_41947_, Items.f_42207_, Items.f_42209_})).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.redQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42451_).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.sunnyQuartz, (int)8).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42206_).m_126130_("QQQ").m_126130_("QCQ").m_126130_("QQQ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42692_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.vineBall).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42029_).m_126130_("VVV").m_126130_("VVV").m_126130_("VVV").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42029_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.necroVirus).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)ModItems.vineBall).m_126209_((ItemLike)Items.f_42542_).m_126209_((ItemLike)Items.f_42592_).m_126209_((ItemLike)Items.f_42545_).m_126209_((ItemLike)Items.f_42681_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42681_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.nullVirus).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)ModItems.vineBall).m_126209_((ItemLike)Items.f_42542_).m_126209_((ItemLike)Items.f_42592_).m_126209_((ItemLike)Items.f_42545_).m_126209_((ItemLike)Items.f_42678_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42678_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.spark).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42587_).m_126130_(" P ").m_126130_("BNB").m_126130_(" P ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42593_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.sparkUpgradeDispersive).m_126209_((ItemLike)ModItems.pixieDust).m_206419_(ModTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)ModItems.runeWater).m_142409_("botania:spark_upgrade").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.spark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.sparkUpgradeDominant).m_126209_((ItemLike)ModItems.pixieDust).m_206419_(ModTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)ModItems.runeFire).m_142409_("botania:spark_upgrade").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.spark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.sparkUpgradeRecessive).m_126209_((ItemLike)ModItems.pixieDust).m_206419_(ModTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)ModItems.runeEarth).m_142409_("botania:spark_upgrade").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.spark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.sparkUpgradeIsolated).m_126209_((ItemLike)ModItems.pixieDust).m_206419_(ModTags.Items.INGOTS_MANASTEEL).m_126209_((ItemLike)ModItems.runeAir).m_142409_("botania:spark_upgrade").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.spark)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.vial, (int)3).m_126127_(Character.valueOf('G'), (ItemLike)ModBlocks.manaGlass).m_126130_("G G").m_126130_(" G ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.manaGlass)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.brewery)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.flask, (int)3).m_126127_(Character.valueOf('G'), (ItemLike)ModBlocks.elfGlass).m_126130_("G G").m_126130_(" G ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.elfGlass)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.worldSeed, (int)4).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42404_).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42276_).m_126130_("G").m_126130_("S").m_126130_("D").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.thornChakram, (int)2).m_206416_(Character.valueOf('T'), ModTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42029_).m_126130_("VVV").m_126130_("VTV").m_126130_("VVV").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModItems.flareChakram, (int)2).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.pixieDust).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('C'), (ItemLike)ModItems.thornChakram).m_126130_("BBB").m_126130_("CPC").m_126130_("BBB").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.thornChakram)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)ModItems.phantomInk, (int)4).m_126209_((ItemLike)ModItems.manaPearl).m_126184_(Ingredient.m_43929_((ItemLike[])((ItemLike[])Arrays.stream(DyeColor.values()).map(DyeItem::m_41082_).toArray(ItemLike[]::new)))).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_, Items.f_42212_, Items.f_42213_, Items.f_42214_, Items.f_42215_, Items.f_42216_, Items.f_42217_, Items.f_42218_, Items.f_42219_, Items.f_42220_, Items.f_42221_, Items.f_42222_, Items.f_42171_, Items.f_42172_, Items.f_42173_, Items.f_42174_, Items.f_42175_})).m_126211_((ItemLike)Items.f_42590_, 4).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.keepIvy).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)Items.f_42029_).m_126209_((ItemLike)ModItems.enderAirBottle).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.enderAirBottle)).m_176498_(consumer);
    }

    private void registerMisc(Consumer<FinishedRecipe> consumer) {
        Ingredient mushrooms = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.whiteMushroom, ModBlocks.orangeMushroom, ModBlocks.magentaMushroom, ModBlocks.lightBlueMushroom, ModBlocks.yellowMushroom, ModBlocks.limeMushroom, ModBlocks.pinkMushroom, ModBlocks.grayMushroom, ModBlocks.lightGrayMushroom, ModBlocks.cyanMushroom, ModBlocks.purpleMushroom, ModBlocks.blueMushroom, ModBlocks.brownMushroom, ModBlocks.greenMushroom, ModBlocks.redMushroom, ModBlocks.blackMushroom});
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42400_).m_126186_(mushrooms, 2).m_126209_((ItemLike)Items.f_42399_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42399_)).m_142284_("has_orig_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)new ResourceLocation("mushroom_stew"))).m_176500_(consumer, "botania:mushroom_stew");
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_41863_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('M'), (ItemLike)ModItems.manaString).m_126130_("S S").m_126130_(" M ").m_126130_("S S").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaString)).m_142700_(consumer, this.prefix("cobweb"));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.defaultAltar).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42594_).m_126130_("CPC").m_126130_(" C ").m_126130_("CCC").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.PETALS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.mossyAltar).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41998_).m_126130_("CPC").m_126130_(" C ").m_126130_("CCC").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.PETALS)).m_176498_(consumer);
        for (String string : LibBlockNames.METAMORPHIC_VARIANTS) {
            Block apothecary = (Block)Registry.f_122824_.m_6612_(this.prefix("apothecary_" + string)).get();
            Block cobble = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + string + "_cobblestone")).get();
            ShapedRecipeBuilder.m_126116_((ItemLike)apothecary).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_126127_(Character.valueOf('C'), (ItemLike)cobble).m_126130_("CPC").m_126130_(" C ").m_126130_("CCC").m_142409_("botania:metamorphic_apothecary").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)cobble)).m_142284_("has_flower_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModSubtiles.marimorphosis)).m_176498_(consumer);
        }
        for (String string : DyeColor.values()) {
            ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.getShinyFlower((DyeColor)string)).m_126209_((ItemLike)Items.f_42525_).m_126209_((ItemLike)Items.f_42525_).m_126209_((ItemLike)ModBlocks.getFlower((DyeColor)string)).m_142409_("botania:shiny_flower").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.getFlower((DyeColor)string))).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.getFloatingFlower((DyeColor)string)).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.grassSeeds).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('F'), (ItemLike)ModBlocks.getShinyFlower((DyeColor)string)).m_126130_("F").m_126130_("S").m_126130_("D").m_142409_("botania:floating_flowers").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.getShinyFlower((DyeColor)string))).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.getPetalBlock((DyeColor)string)).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.getPetal((DyeColor)string)).m_126130_("PPP").m_126130_("PPP").m_126130_("PPP").m_142409_("botania:petal_block").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.getPetal((DyeColor)string))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.getMushroom((DyeColor)string)).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41953_, Items.f_41952_})).m_126209_((ItemLike)DyeItem.m_41082_((DyeColor)string)).m_142409_("botania:mushroom").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41953_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41952_)).m_176500_(consumer, "botania:mushroom_" + string.ordinal());
            ShapelessRecipeBuilder.m_126191_((ItemLike)ModItems.getPetal((DyeColor)string), (int)4).m_126209_((ItemLike)ModBlocks.getDoubleFlower((DyeColor)string)).m_142409_("botania:petal_double").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.getDoubleFlower((DyeColor)string))).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.getPetal((DyeColor)string))).m_176500_(consumer, "botania:petal_" + string.m_41065_() + "_double");
            ShapelessRecipeBuilder.m_126191_((ItemLike)ModItems.getPetal((DyeColor)string), (int)2).m_126209_((ItemLike)ModBlocks.getFlower((DyeColor)string)).m_142409_("botania:petal").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.getFlower((DyeColor)string))).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.getPetal((DyeColor)string))).m_176500_(consumer, "botania:petal_" + string.m_41065_());
            ShapelessRecipeBuilder.m_126189_((ItemLike)DyeItem.m_41082_((DyeColor)string)).m_126184_(Ingredient.m_204132_(ModTags.Items.getPetalTag((DyeColor)string))).m_142409_("botania:dye").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.getPetal((DyeColor)string))).m_176500_(consumer, "botania:dye_" + string.m_41065_());
        }
    }

    private void registerTools(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lexicon).m_206419_(ItemTags.f_13180_).m_126209_((ItemLike)Items.f_42517_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag((TagKey<Item>)ItemTags.f_13180_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42517_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.twigWand).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.livingwoodTwig).m_126130_(" PS").m_126130_(" SP").m_126130_("S  ").m_142409_("botania:twig_wand").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.PETALS)).m_176498_(WrapperResult.ofType(TwigWandRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.dreamwoodWand).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.dreamwoodTwig).m_126130_(" PS").m_126130_(" SP").m_126130_("S  ").m_142409_("botania:twig_wand").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.PETALS)).m_176498_(WrapperResult.ofType(TwigWandRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.manaTablet).m_126124_(Character.valueOf('P'), AccessorIngredient.callFromValues(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)ModItems.manaPearl)), new Ingredient.TagValue(ModTags.Items.GEMS_MANA_DIAMOND)))).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.livingrock).m_126130_("SSS").m_126130_("SPS").m_126130_("SSS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.cacophonium).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_41859_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_151052_).m_126130_(" G ").m_126130_("GNG").m_126130_("GG ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41859_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.grassHorn).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.grassSeeds).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126130_(" W ").m_126130_("WSW").m_126130_("WW ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.LIVINGWOOD_LOGS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.leavesHorn).m_126209_((ItemLike)ModItems.grassHorn).m_206419_(ItemTags.f_13143_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassHorn)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.snowHorn).m_126209_((ItemLike)ModItems.grassHorn).m_126209_((ItemLike)Items.f_42452_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.grassHorn)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.manaMirror).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrock).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.manaTablet).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_TERRASTEEL).m_126130_(" PR").m_126130_(" SI").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaTablet)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.openBucket).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("E E").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.spawnerMover).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.enderAirBottle).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.lifeEssence).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("EIE").m_126130_("ADA").m_126130_("EIE").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.slingshot).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126130_(" TA").m_126130_(" TT").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeAir)).m_176498_(consumer);
        this.registerSimpleArmorSet(consumer, Ingredient.m_204132_(ModTags.Items.INGOTS_MANASTEEL), "manasteel", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL));
        this.registerSimpleArmorSet(consumer, Ingredient.m_204132_(ModTags.Items.INGOTS_ELEMENTIUM), "elementium", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM));
        this.registerSimpleArmorSet(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.manaweaveCloth}), "manaweave", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaweaveCloth));
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)ModItems.terrasteelHelm, (ItemLike)ModItems.manasteelHelm, (ItemLike)ModItems.runeSpring);
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)ModItems.terrasteelChest, (ItemLike)ModItems.manasteelChest, (ItemLike)ModItems.runeSummer);
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)ModItems.terrasteelLegs, (ItemLike)ModItems.manasteelLegs, (ItemLike)ModItems.runeAutumn);
        this.registerTerrasteelUpgradeRecipe(consumer, (ItemLike)ModItems.terrasteelBoots, (ItemLike)ModItems.manasteelBoots, (ItemLike)ModItems.runeWinter);
        this.registerToolSetRecipes(consumer, Ingredient.m_204132_(ModTags.Items.INGOTS_MANASTEEL), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.livingwoodTwig}), (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL), (ItemLike)ModItems.manasteelSword, (ItemLike)ModItems.manasteelPick, (ItemLike)ModItems.manasteelAxe, (ItemLike)ModItems.manasteelHoe, (ItemLike)ModItems.manasteelShovel, (ItemLike)ModItems.manasteelShears);
        this.registerToolSetRecipes(consumer, Ingredient.m_204132_(ModTags.Items.INGOTS_ELEMENTIUM), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.dreamwoodTwig}), (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM), (ItemLike)ModItems.elementiumSword, (ItemLike)ModItems.elementiumPick, (ItemLike)ModItems.elementiumAxe, (ItemLike)ModItems.elementiumHoe, (ItemLike)ModItems.elementiumShovel, (ItemLike)ModItems.elementiumShears);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.terraSword).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_TERRASTEEL).m_126130_("I").m_126130_("I").m_126130_("S").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.terraPick).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.manaTablet).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.livingwoodTwig).m_126130_("ITI").m_126130_("ILI").m_126130_(" L ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.terraAxe).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('T'), ModTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42054_).m_126130_("TTG").m_126130_("TST").m_126130_(" S ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.starSword).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.enderAirBottle).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.terraSword).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("  I").m_126130_("AD ").m_126130_("TA ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.terraAxe)).m_142284_("has_terrasteel", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.thunderSword).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.enderAirBottle).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.terraSword).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("  I").m_126130_("AD ").m_126130_("TA ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.terraAxe)).m_142284_("has_terrasteel", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.glassPick).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_41904_).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("GIG").m_126130_(" T ").m_126130_(" T ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.livingwoodBow).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126130_(" TS").m_126130_("T S").m_126130_(" TS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaString)).m_142284_("has_twig", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.livingwoodTwig)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.crystalBow).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126130_(" DS").m_126130_("T S").m_126130_(" DS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.enderDagger).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126130_("P").m_126130_("S").m_126130_("T").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.enderHand).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42108_).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("PLO").m_126130_("LEL").m_126130_("OL ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42108_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42545_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)ModItems.placeholder, (int)32).m_126209_((ItemLike)Items.f_41960_).m_126209_((ItemLike)ModBlocks.livingrock).m_142284_("has_dreamwood", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.DREAMWOOD_LOGS)).m_142284_("has_crafty_crate", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.craftCrate)).m_176498_(consumer);
        for (CratePattern pattern : CratePattern.values()) {
            if (pattern == CratePattern.NONE) continue;
            Item item = (Item)Registry.f_122827_.m_6612_(this.prefix("pattern_" + pattern.m_7912_().split("_", 2)[1])).get();
            String s = pattern.openSlots.stream().map(bool -> bool != false ? "R" : "P").collect(Collectors.joining());
            ShapedRecipeBuilder.m_126116_((ItemLike)item).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.placeholder).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126130_(s.substring(0, 3)).m_126130_(s.substring(3, 6)).m_126130_(s.substring(6, 9)).m_142409_("botania:craft_pattern").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.placeholder)).m_142284_("has_crafty_crate", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.craftCrate)).m_176498_(consumer);
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.manaGun).m_126127_(Character.valueOf('S'), (ItemLike)ModBlocks.redstoneSpreader).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_41996_).m_206416_(Character.valueOf('W'), ModTags.Items.LIVINGWOOD_LOGS).m_126127_(Character.valueOf('M'), (ItemLike)ModItems.runeMana).m_126130_("SMD").m_126130_(" WT").m_126130_("  W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.dirtRod).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42329_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.runeEarth).m_126130_("  D").m_126130_(" T ").m_126130_("E  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeEarth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.terraformRod).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeAutumn).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.dirtRod).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.runeSpring).m_206416_(Character.valueOf('T'), ModTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.grassSeeds).m_126127_(Character.valueOf('W'), (ItemLike)ModItems.runeWinter).m_126127_(Character.valueOf('M'), (ItemLike)ModItems.runeSummer).m_126130_(" WT").m_126130_("ARS").m_126130_("GM ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.waterRod).m_126124_(Character.valueOf('B'), Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)})).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeWater).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126130_("  B").m_126130_(" T ").m_126130_("R  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeWater)).m_176498_(WrapperResult.ofType(WaterBottleMatchingRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.rainbowRod).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.pixieDust).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_(" PD").m_126130_(" EP").m_126130_("E  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.tornadoRod).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42402_).m_126130_("  F").m_126130_(" T ").m_126130_("R  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeAir)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.fireRod).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeFire).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42593_).m_126130_("  F").m_126130_(" T ").m_126130_("R  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeFire)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.skyDirtRod).m_126209_((ItemLike)ModItems.dirtRod).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)ModItems.runeAir).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.diviningRod).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126130_(" TD").m_126130_(" TT").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.gravityRod).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.dreamwoodTwig).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42405_).m_126130_(" TD").m_126130_(" WT").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_DRAGONSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.missileRod).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.dreamwoodTwig).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.lifeEssence).m_126130_("GDD").m_126130_(" TD").m_126130_("T G").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.cobbleRod).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42594_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)ModItems.runeFire).m_126127_(Character.valueOf('W'), (ItemLike)ModItems.runeWater).m_126130_(" FC").m_126130_(" TW").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeFire)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeWater)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.smeltRod).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('F'), (ItemLike)ModItems.runeFire).m_126130_(" BF").m_126130_(" TB").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeFire)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.exchangeRod).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeSloth).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126130_(" SR").m_126130_(" TS").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeSloth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.laputaShard).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.lifeEssence).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.runeEarth).m_206416_(Character.valueOf('F'), ModTags.Items.MUNDANE_FLOATING_FLOWERS).m_126130_("SFS").m_126130_("PDP").m_126130_("ASE").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.craftingHalo).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41960_).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126130_(" P ").m_126130_("ICI").m_126130_(" I ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.clip).m_206416_(Character.valueOf('D'), ModTags.Items.DREAMWOOD_LOGS).m_126130_(" D ").m_126130_("D D").m_126130_("DD ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.DREAMWOOD_LOGS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.spellCloth).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('C'), (ItemLike)ModItems.manaweaveCloth).m_126130_(" C ").m_126130_("CPC").m_126130_(" C ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaweaveCloth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.flowerBag).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS).m_206416_(Character.valueOf('W'), ItemTags.f_13167_).m_126130_("WPW").m_126130_("W W").m_126130_(" W ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.MYSTICAL_FLOWERS)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.poolMinecart).m_126209_((ItemLike)Items.f_42449_).m_126209_((ItemLike)ModBlocks.manaPool).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.blackHoleTalisman).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.enderAirBottle).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.lifeEssence).m_126130_(" G ").m_126130_("EAE").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.temperanceStone).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeEarth).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126130_(" S ").m_126130_("SRS").m_126130_(" S ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeEarth)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.incenseStick).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42586_).m_126130_("  G").m_126130_(" B ").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42586_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.obedienceStick).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("  M").m_126130_(" T ").m_126130_("T  ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.slimeBottle).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42518_).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)ModBlocks.elfGlass).m_126130_("EGE").m_126130_("ESE").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.autocraftingHalo).m_126209_((ItemLike)ModItems.craftingHalo).m_206419_(ModTags.Items.GEMS_MANA_DIAMOND).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.sextant).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126130_(" TI").m_126130_(" TT").m_126130_("III").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.astrolabe).m_206416_(Character.valueOf('D'), ModTags.Items.DREAMWOOD_LOGS).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.lifeEssence).m_126130_(" EG").m_126130_("EEE").m_126130_("GED").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
    }

    private void registerTrinkets(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.tinyPlanet).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41905_).m_126127_(Character.valueOf('L'), (ItemLike)ModBlocks.livingrock).m_126130_("LSL").m_126130_("SPS").m_126130_("LSL").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.manaRing).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.manaTablet).m_126127_(Character.valueOf('I'), (ItemLike)ModItems.manaSteel).m_126130_("TI ").m_126130_("I I").m_126130_(" I ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaTablet)).m_176498_(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.auraRing).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeMana).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("RI ").m_126130_("I I").m_126130_(" I ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.runeMana)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.manaRingGreater).m_206419_(ModTags.Items.INGOTS_TERRASTEEL).m_126209_((ItemLike)ModItems.manaRing).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.terrasteel)).m_176498_(WrapperResult.ofType(ShapelessManaUpgradeRecipe.SERIALIZER, consumer));
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.auraRingGreater).m_206419_(ModTags.Items.INGOTS_TERRASTEEL).m_126209_((ItemLike)ModItems.auraRing).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.travelBelt).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeAir).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.runeEarth).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("EL ").m_126130_("L L").m_126130_("SLA").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.knockbackBelt).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeFire).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.runeEarth).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42454_).m_126130_("AL ").m_126130_("L L").m_126130_("SLE").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.icePendant).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeWater).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_126127_(Character.valueOf('W'), (ItemLike)ModItems.runeWinter).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("WS ").m_126130_("S S").m_126130_("MSR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lavaPendant).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_206416_(Character.valueOf('D'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('F'), (ItemLike)ModItems.runeFire).m_126127_(Character.valueOf('M'), (ItemLike)ModItems.runeSummer).m_126130_("MS ").m_126130_("S S").m_126130_("DSF").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.magnetRing).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensMagnet).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("LM ").m_126130_("M M").m_126130_(" M ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.waterRing).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42529_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42526_).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42716_).m_126127_(Character.valueOf('W'), (ItemLike)ModItems.runeWater).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("WMP").m_126130_("MHM").m_126130_("CM ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42716_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.miningRing).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42432_).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.runeEarth).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("EMP").m_126130_("M M").m_126130_(" M ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.divaCharm).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.tinyPlanet).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('H'), (ItemLike)ModItems.runePride).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lifeEssence).m_126130_("LGP").m_126130_(" HG").m_126130_(" GL").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.flightTiara).m_126127_(Character.valueOf('E'), (ItemLike)ModItems.enderAirBottle).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42402_).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lifeEssence).m_126130_("LLL").m_126130_("ILI").m_126130_("FEF").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176500_(consumer, "botania:flighttiara_0");
        Item[] items = new Item[]{Items.f_42692_, ModItems.darkQuartz, ModItems.manaQuartz, ModItems.blazeQuartz, ModItems.lavenderQuartz, ModItems.redQuartz, ModItems.elfQuartz, ModItems.sunnyQuartz};
        for (int i = 0; i < items.length; ++i) {
            int tiaraType = i + 1;
            ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.flightTiara).m_126209_((ItemLike)ModItems.flightTiara).m_126209_((ItemLike)items[i]).m_142409_("botania:flight_tiara_wings").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.flightTiara)).m_176500_(NbtOutputResult.with(consumer, tag -> tag.m_128405_("variant", tiaraType)), "botania:flighttiara_" + tiaraType);
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.pixieRing).m_126127_(Character.valueOf('D'), (ItemLike)ModItems.pixieDust).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("DE ").m_126130_("E E").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.superTravelBelt).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.travelBelt).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lifeEssence).m_126130_("E  ").m_126130_(" S ").m_126130_("L E").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.reachRing).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runePride).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126130_("RE ").m_126130_("E E").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.itemFinder).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42545_).m_126130_(" I ").m_126130_("IYI").m_126130_("IEI").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42545_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.superLavaPendant).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.lavaPendant).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42585_).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.lifeEssence).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42691_).m_126130_("BBB").m_126130_("BPB").m_126130_("NGN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.bloodPendant).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42586_).m_126130_(" P ").m_126130_("PGP").m_126130_("DP ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42586_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.holyCloak).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.lifeEssence).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41870_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42525_).m_126130_("WWW").m_126130_("GWG").m_126130_("GSG").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.unholyCloak).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.lifeEssence).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41938_).m_126130_("WWW").m_126130_("RWR").m_126130_("RSR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.balanceCloak).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.lifeEssence).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41878_).m_126130_("WWW").m_126130_("RWR").m_126130_("RSR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.monocle).m_126127_(Character.valueOf('G'), (ItemLike)ModBlocks.manaGlass).m_206416_(Character.valueOf('I'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42587_).m_126130_("GN").m_126130_("IN").m_126130_(" N").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.swapRing).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41983_).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("CM ").m_126130_("M M").m_126130_(" M ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.magnetRingGreater).m_206419_(ModTags.Items.INGOTS_TERRASTEEL).m_126209_((ItemLike)ModItems.magnetRing).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.magnetRing)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.speedUpBelt).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.grassSeeds).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.travelBelt).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('M'), (ItemLike)Items.f_42676_).m_126130_(" M ").m_126130_("PBP").m_126130_(" S ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42676_)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.travelBelt)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.dodgeRing).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42616_).m_206416_(Character.valueOf('M'), ModTags.Items.INGOTS_MANASTEEL).m_126130_("EM ").m_126130_("M M").m_126130_(" MR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.invisibilityCloak).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.manaPearl).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41870_).m_126127_(Character.valueOf('G'), (ItemLike)ModBlocks.manaGlass).m_126130_("CWC").m_126130_("GWG").m_126130_("GPG").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaPearl)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.cloudPendant).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_206416_(Character.valueOf('D'), ModTags.Items.INGOTS_MANASTEEL).m_126127_(Character.valueOf('F'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('M'), (ItemLike)ModItems.runeAutumn).m_126130_("MS ").m_126130_("S S").m_126130_("DSF").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaString)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.superCloudPendant).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.cloudPendant).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42586_).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_126127_(Character.valueOf('G'), (ItemLike)ModItems.lifeEssence).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_41870_).m_126130_("BEB").m_126130_("BPB").m_126130_("NGN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.cloudPendant)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lifeEssence)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.thirdEye).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42157_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42677_).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.runeEarth).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126130_("RSR").m_126130_("QEQ").m_126130_("RDR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.goddessCharm).m_206416_(Character.valueOf('P'), ModTags.Items.PETALS_PINK).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.runeWater).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.runeSpring).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_MANA_DIAMOND).m_126130_(" P ").m_126130_(" P ").m_126130_("ADS").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.GEMS_MANA_DIAMOND)).m_176498_(consumer);
    }

    private void registerCorporeaAndRedString(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.redString).m_126209_((ItemLike)Items.f_42401_).m_126209_((ItemLike)Items.f_42153_).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)ModItems.enderAirBottle).m_142409_("botania:red_string").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.enderAirBottle)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.redString).m_126209_((ItemLike)Items.f_42401_).m_126209_((ItemLike)Items.f_42153_).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)ModItems.enderAirBottle).m_126209_((ItemLike)Items.f_42046_).m_142409_("botania:red_string").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.enderAirBottle)).m_176500_(consumer, "botania:red_string_alt");
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)ModBlocks.redStringDispenser, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41855_}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_41855_));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)ModBlocks.redStringFertilizer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.fertilizer}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.fertilizer));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)ModBlocks.redStringComparator, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42351_}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42351_));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)ModBlocks.redStringRelay, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModBlocks.manaSpreader}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.manaSpreader));
        RecipeProvider.registerRedStringBlock(consumer, (ItemLike)ModBlocks.redStringInterceptor, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42083_}), (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42083_));
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.corporeaSpark).m_126209_((ItemLike)ModItems.spark).m_126209_((ItemLike)ModItems.pixieDust).m_126209_((ItemLike)ModItems.enderAirBottle).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.enderAirBottle)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.corporeaSparkMaster).m_126209_((ItemLike)ModItems.corporeaSpark).m_206419_(ModTags.Items.GEMS_DRAGONSTONE).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.corporeaSpark)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.corporeaIndex).m_126127_(Character.valueOf('A'), (ItemLike)ModItems.enderAirBottle).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.corporeaSpark).m_206416_(Character.valueOf('D'), ModTags.Items.GEMS_DRAGONSTONE).m_126127_(Character.valueOf('O'), (ItemLike)Items.f_41999_).m_126130_("AOA").m_126130_("OSO").m_126130_("DOD").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.corporeaSpark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.corporeaFunnel).m_126209_((ItemLike)Items.f_42162_).m_126209_((ItemLike)ModItems.corporeaSpark).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.corporeaSpark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.corporeaInterceptor).m_126209_((ItemLike)Items.f_42153_).m_126209_((ItemLike)ModItems.corporeaSpark).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.corporeaSpark)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.corporeaCrystalCube).m_126127_(Character.valueOf('C'), (ItemLike)ModItems.corporeaSpark).m_126127_(Character.valueOf('G'), (ItemLike)ModBlocks.elfGlass).m_206416_(Character.valueOf('W'), ModTags.Items.DREAMWOOD_LOGS).m_126130_("C").m_126130_("G").m_126130_("W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.corporeaSpark)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)ModBlocks.corporeaBlock, (int)8).m_126209_((ItemLike)ModBlocks.livingrockBrick).m_126209_((ItemLike)ModItems.corporeaSpark).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.corporeaSpark)).m_176498_(consumer);
        this.slabShape((ItemLike)ModBlocks.corporeaSlab, (ItemLike)ModBlocks.corporeaBlock).m_176498_(consumer);
        this.stairs((ItemLike)ModBlocks.corporeaStairs, (ItemLike)ModBlocks.corporeaBlock).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModBlocks.corporeaBrick, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.corporeaBlock).m_126130_("RR").m_126130_("RR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.corporeaBlock)).m_176498_(consumer);
        this.slabShape((ItemLike)ModBlocks.corporeaBrickSlab, (ItemLike)ModBlocks.corporeaBrick).m_176498_(consumer);
        this.stairs((ItemLike)ModBlocks.corporeaBrickStairs, (ItemLike)ModBlocks.corporeaBrick).m_176498_(consumer);
        this.wallShape((ItemLike)ModBlocks.corporeaBrickWall, (ItemLike)ModBlocks.corporeaBrick, 6).m_176498_(consumer);
    }

    private void registerLenses(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensNormal).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_MANASTEEL).m_126124_(Character.valueOf('G'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_, Items.f_42027_})).m_126130_(" S ").m_126130_("SGS").m_126130_(" S ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_MANASTEEL)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensSpeed).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeAir).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensPower).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeFire).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensTime).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeEarth).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensEfficiency).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeWater).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensBounce).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeSummer).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensGravity).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeWinter).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensMine).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42534_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_(" P ").m_126130_("ALA").m_126130_(" R ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensDamage).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeWrath).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensPhantom).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModBlocks.abstrusePlatform).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensMagnet).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)Items.f_42416_).m_126209_((ItemLike)Items.f_42417_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensExplosive).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.runeEnvy).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensInfluence).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeAir).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_("PRP").m_126130_("PLP").m_126130_("PPP").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensWeight).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42696_).m_126127_(Character.valueOf('R'), (ItemLike)ModItems.runeWater).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_("PPP").m_126130_("PLP").m_126130_("PRP").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensPaint).m_206416_(Character.valueOf('E'), ModTags.Items.INGOTS_ELEMENTIUM).m_206416_(Character.valueOf('W'), ItemTags.f_13167_).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_(" E ").m_126130_("WLW").m_126130_(" E ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensFire).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensPiston).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModBlocks.pistonRelay).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensLight).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42613_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42054_).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_("GFG").m_126130_("FLF").m_126130_("GFG").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensLight).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42613_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42054_).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_("FGF").m_126130_("GLG").m_126130_("FGF").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176500_(consumer, "botania:lens_light_alt");
        ShapedRecipeBuilder.m_126116_((ItemLike)ModItems.lensMessenger).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('L'), (ItemLike)ModItems.lensNormal).m_126130_(" P ").m_126130_("PLP").m_126130_(" P ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.lensNormal)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensWarp).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModItems.pixieDust).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.pixieDust)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensRedirect).m_126209_((ItemLike)ModItems.lensNormal).m_206419_(ModTags.Items.LIVINGWOOD_LOGS).m_206419_(ModTags.Items.INGOTS_ELEMENTIUM).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensFirework).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)Items.f_42688_).m_206419_(ModTags.Items.INGOTS_ELEMENTIUM).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensFlare).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)ModBlocks.elfGlass).m_206419_(ModTags.Items.INGOTS_ELEMENTIUM).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModItems.lensTripwire).m_126209_((ItemLike)ModItems.lensNormal).m_126209_((ItemLike)Items.f_42109_).m_206419_(ModTags.Items.INGOTS_ELEMENTIUM).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_ELEMENTIUM)).m_176498_(consumer);
    }

    private void registerFloatingFlowers(Consumer<FinishedRecipe> consumer) {
        for (Block block : new Block[]{ModSubtiles.pureDaisy, ModSubtiles.manastar, ModSubtiles.hydroangeas, ModSubtiles.endoflame, ModSubtiles.thermalily, ModSubtiles.rosaArcana, ModSubtiles.munchdew, ModSubtiles.entropinnyum, ModSubtiles.kekimurus, ModSubtiles.gourmaryllis, ModSubtiles.narslimmus, ModSubtiles.spectrolus, ModSubtiles.dandelifeon, ModSubtiles.rafflowsia, ModSubtiles.shulkMeNot, ModSubtiles.bellethorn, ModSubtiles.bellethornChibi, ModSubtiles.bergamute, ModSubtiles.dreadthorn, ModSubtiles.heiseiDream, ModSubtiles.tigerseye, ModSubtiles.jadedAmaranthus, ModSubtiles.orechid, ModSubtiles.fallenKanade, ModSubtiles.exoflame, ModSubtiles.agricarnation, ModSubtiles.agricarnationChibi, ModSubtiles.hopperhock, ModSubtiles.hopperhockChibi, ModSubtiles.tangleberrie, ModSubtiles.tangleberrieChibi, ModSubtiles.jiyuulia, ModSubtiles.jiyuuliaChibi, ModSubtiles.rannuncarpus, ModSubtiles.rannuncarpusChibi, ModSubtiles.hyacidus, ModSubtiles.pollidisiac, ModSubtiles.clayconia, ModSubtiles.clayconiaChibi, ModSubtiles.loonium, ModSubtiles.daffomill, ModSubtiles.vinculotus, ModSubtiles.spectranthemum, ModSubtiles.medumone, ModSubtiles.marimorphosis, ModSubtiles.marimorphosisChibi, ModSubtiles.bubbell, ModSubtiles.bubbellChibi, ModSubtiles.solegnolia, ModSubtiles.solegnoliaChibi, ModSubtiles.orechidIgnem, ModSubtiles.labellia}) {
            this.createFloatingFlowerRecipe(consumer, (ItemLike)block);
        }
    }

    private void registerConversions(Consumer<FinishedRecipe> consumer) {
        this.compression((ItemLike)ModItems.manaSteel, ModTags.Items.NUGGETS_MANASTEEL).m_142700_(consumer, this.prefix("conversions/manasteel_from_nuggets"));
        this.compression((ItemLike)ModItems.elementium, ModTags.Items.NUGGETS_ELEMENTIUM).m_142700_(consumer, this.prefix("conversions/elementium_from_nuggets"));
        this.compression((ItemLike)ModItems.terrasteel, ModTags.Items.NUGGETS_TERRASTEEL).m_142700_(consumer, this.prefix("conversions/terrasteel_from_nugget"));
        this.compression((ItemLike)ModBlocks.manasteelBlock, ModTags.Items.INGOTS_MANASTEEL).m_176498_(consumer);
        this.compression((ItemLike)ModBlocks.terrasteelBlock, ModTags.Items.INGOTS_TERRASTEEL).m_176498_(consumer);
        this.compression((ItemLike)ModBlocks.elementiumBlock, ModTags.Items.INGOTS_ELEMENTIUM).m_176498_(consumer);
        this.compression((ItemLike)ModBlocks.manaDiamondBlock, ModTags.Items.GEMS_MANA_DIAMOND).m_176498_(consumer);
        this.compression((ItemLike)ModBlocks.dragonstoneBlock, ModTags.Items.GEMS_DRAGONSTONE).m_176498_(consumer);
        MutableObject base = new MutableObject();
        MutableObject gog = new MutableObject();
        this.compression((ItemLike)ModBlocks.blazeBlock, (ItemLike)Items.f_42585_).m_176498_(arg_0 -> ((MutableObject)base).setValue(arg_0));
        ShapedRecipeBuilder.m_126116_((ItemLike)ModBlocks.blazeBlock).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42593_).m_126130_("III").m_126130_("III").m_126130_("III").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)Items.f_42593_)).m_176498_(arg_0 -> ((MutableObject)gog).setValue(arg_0));
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.whitePetal, (ItemLike)ModBlocks.petalBlockWhite);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.orangePetal, (ItemLike)ModBlocks.petalBlockOrange);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.magentaPetal, (ItemLike)ModBlocks.petalBlockMagenta);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.lightBluePetal, (ItemLike)ModBlocks.petalBlockLightBlue);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.yellowPetal, (ItemLike)ModBlocks.petalBlockYellow);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.limePetal, (ItemLike)ModBlocks.petalBlockLime);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.pinkPetal, (ItemLike)ModBlocks.petalBlockPink);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.grayPetal, (ItemLike)ModBlocks.petalBlockGray);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.lightGrayPetal, (ItemLike)ModBlocks.petalBlockSilver);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.cyanPetal, (ItemLike)ModBlocks.petalBlockCyan);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.purplePetal, (ItemLike)ModBlocks.petalBlockPurple);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.bluePetal, (ItemLike)ModBlocks.petalBlockBlue);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.brownPetal, (ItemLike)ModBlocks.petalBlockBrown);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.greenPetal, (ItemLike)ModBlocks.petalBlockGreen);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.redPetal, (ItemLike)ModBlocks.petalBlockRed);
        this.deconstructPetalBlock(consumer, (ItemLike)ModItems.blackPetal, (ItemLike)ModBlocks.petalBlockBlack);
        this.deconstruct(arg_0 -> ((MutableObject)base).setValue(arg_0), (ItemLike)Items.f_42585_, (ItemLike)ModBlocks.blazeBlock, "blazeblock_deconstruct");
        this.deconstruct(arg_0 -> ((MutableObject)gog).setValue(arg_0), (ItemLike)Items.f_42593_, (ItemLike)ModBlocks.blazeBlock, "blazeblock_deconstruct");
        consumer.accept(new GogAlternationResult((FinishedRecipe)gog.getValue(), (FinishedRecipe)base.getValue()));
        this.deconstruct(consumer, (ItemLike)ModItems.manaSteel, ModTags.Items.BLOCKS_MANASTEEL, "manasteel_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)ModItems.manaDiamond, (ItemLike)ModBlocks.manaDiamondBlock, "manadiamond_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)ModItems.terrasteel, ModTags.Items.BLOCKS_TERRASTEEL, "terrasteel_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)ModItems.elementium, ModTags.Items.BLOCKS_ELEMENTIUM, "elementium_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)ModItems.dragonstone, (ItemLike)ModBlocks.dragonstoneBlock, "dragonstone_block_deconstruct");
        this.deconstruct(consumer, (ItemLike)ModItems.manasteelNugget, ModTags.Items.INGOTS_MANASTEEL, "manasteel_to_nuggets");
        this.deconstruct(consumer, (ItemLike)ModItems.terrasteelNugget, ModTags.Items.INGOTS_TERRASTEEL, "terrasteel_to_nugget");
        this.deconstruct(consumer, (ItemLike)ModItems.elementiumNugget, ModTags.Items.INGOTS_ELEMENTIUM, "elementium_to_nuggets");
        this.recombineSlab(consumer, (ItemLike)ModBlocks.livingrock, (ItemLike)ModFluffBlocks.livingrockSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.livingrockBrick, (ItemLike)ModFluffBlocks.livingrockBrickSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.livingwood, (ItemLike)ModFluffBlocks.livingwoodSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.livingwoodPlanks, (ItemLike)ModFluffBlocks.livingwoodPlankSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.dreamwood, (ItemLike)ModFluffBlocks.dreamwoodSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.dreamwoodPlanks, (ItemLike)ModFluffBlocks.dreamwoodPlankSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.shimmerrock, (ItemLike)ModFluffBlocks.shimmerrockSlab);
        this.recombineSlab(consumer, (ItemLike)ModBlocks.shimmerwoodPlanks, (ItemLike)ModFluffBlocks.shimmerwoodPlankSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneForest, (ItemLike)ModFluffBlocks.biomeStoneForestSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickForest, (ItemLike)ModFluffBlocks.biomeBrickForestSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneForest, (ItemLike)ModFluffBlocks.biomeCobblestoneForestSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStonePlains, (ItemLike)ModFluffBlocks.biomeStonePlainsSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickPlains, (ItemLike)ModFluffBlocks.biomeBrickPlainsSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestonePlains, (ItemLike)ModFluffBlocks.biomeCobblestonePlainsSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneMountain, (ItemLike)ModFluffBlocks.biomeStoneMountainSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickMountain, (ItemLike)ModFluffBlocks.biomeBrickMountainSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneMountain, (ItemLike)ModFluffBlocks.biomeCobblestoneMountainSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneFungal, (ItemLike)ModFluffBlocks.biomeStoneFungalSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickFungal, (ItemLike)ModFluffBlocks.biomeBrickFungalSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneFungal, (ItemLike)ModFluffBlocks.biomeCobblestoneFungalSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneSwamp, (ItemLike)ModFluffBlocks.biomeStoneSwampSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickSwamp, (ItemLike)ModFluffBlocks.biomeBrickSwampSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneSwamp, (ItemLike)ModFluffBlocks.biomeCobblestoneSwampSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneDesert, (ItemLike)ModFluffBlocks.biomeStoneDesertSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickDesert, (ItemLike)ModFluffBlocks.biomeBrickDesertSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneDesert, (ItemLike)ModFluffBlocks.biomeCobblestoneDesertSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneTaiga, (ItemLike)ModFluffBlocks.biomeStoneTaigaSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickTaiga, (ItemLike)ModFluffBlocks.biomeBrickTaigaSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneTaiga, (ItemLike)ModFluffBlocks.biomeCobblestoneTaigaSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeStoneMesa, (ItemLike)ModFluffBlocks.biomeStoneMesaSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeBrickMesa, (ItemLike)ModFluffBlocks.biomeBrickMesaSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.biomeCobblestoneMesa, (ItemLike)ModFluffBlocks.biomeCobblestoneMesaSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.whitePavement, (ItemLike)ModFluffBlocks.whitePavementSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.blackPavement, (ItemLike)ModFluffBlocks.blackPavementSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.bluePavement, (ItemLike)ModFluffBlocks.bluePavementSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.yellowPavement, (ItemLike)ModFluffBlocks.yellowPavementSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.redPavement, (ItemLike)ModFluffBlocks.redPavementSlab);
        this.recombineSlab(consumer, (ItemLike)ModFluffBlocks.greenPavement, (ItemLike)ModFluffBlocks.greenPavementSlab);
    }

    private void registerDecor(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)ModBlocks.livingrockBrick, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrock).m_126130_("RR").m_126130_("RR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)ModBlocks.livingrockBrickChiseled, (int)4).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrockBrick).m_126130_("RR").m_126130_("RR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrockBrick)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.livingrockBrickMossy).m_126209_((ItemLike)ModBlocks.livingrockBrick).m_126209_((ItemLike)Items.f_151016_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrockBrick)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.livingrockBrickMossy).m_126209_((ItemLike)ModBlocks.livingrockBrick).m_126209_((ItemLike)Items.f_42029_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrockBrick)).m_176500_(consumer, "botania:mossy_livingrock_bricks_vine");
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.shimmerrock).m_126209_((ItemLike)ModBlocks.livingrock).m_126209_((ItemLike)ModBlocks.bifrostPerm).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.bifrostPerm)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.rainbowRod)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)ModBlocks.shimmerwoodPlanks).m_126209_((ItemLike)ModBlocks.dreamwoodPlanks).m_126209_((ItemLike)ModBlocks.bifrostPerm).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.bifrostPerm)).m_142284_("has_alt_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.rainbowRod)).m_176498_(consumer);
        this.registerForQuartz(consumer, "dark_quartz", (ItemLike)ModItems.darkQuartz);
        this.registerForQuartz(consumer, "mana_quartz", (ItemLike)ModItems.manaQuartz);
        this.registerForQuartz(consumer, "blaze_quartz", (ItemLike)ModItems.blazeQuartz);
        this.registerForQuartz(consumer, "lavender_quartz", (ItemLike)ModItems.lavenderQuartz);
        this.registerForQuartz(consumer, "red_quartz", (ItemLike)ModItems.redQuartz);
        this.registerForQuartz(consumer, "elf_quartz", (ItemLike)ModItems.elfQuartz);
        this.registerForQuartz(consumer, "sunny_quartz", (ItemLike)ModItems.sunnyQuartz);
        this.registerForWood(consumer, "livingwood");
        this.registerForWood(consumer, "dreamwood");
        this.stairs((ItemLike)ModFluffBlocks.livingrockStairs, (ItemLike)ModBlocks.livingrock).m_176498_(consumer);
        this.slabShape((ItemLike)ModFluffBlocks.livingrockSlab, (ItemLike)ModBlocks.livingrock).m_176498_(consumer);
        this.wallShape((ItemLike)ModFluffBlocks.livingrockWall, (ItemLike)ModBlocks.livingrock, 6).m_176498_(consumer);
        this.stairs((ItemLike)ModFluffBlocks.livingrockBrickStairs, (ItemLike)ModBlocks.livingrockBrick).m_176498_(consumer);
        this.slabShape((ItemLike)ModFluffBlocks.livingrockBrickSlab, (ItemLike)ModBlocks.livingrockBrick).m_176498_(consumer);
        this.wallShape((ItemLike)ModFluffBlocks.livingrockBrickWall, (ItemLike)ModBlocks.livingrockBrick, 6).m_176498_(consumer);
        this.stairs((ItemLike)ModFluffBlocks.livingrockBrickMossyStairs, (ItemLike)ModBlocks.livingrockBrickMossy).m_176498_(consumer);
        this.slabShape((ItemLike)ModFluffBlocks.livingrockBrickMossySlab, (ItemLike)ModBlocks.livingrockBrickMossy).m_176498_(consumer);
        this.wallShape((ItemLike)ModFluffBlocks.livingrockBrickMossyWall, (ItemLike)ModBlocks.livingrockBrickMossy, 6).m_176498_(consumer);
        this.stairs((ItemLike)ModFluffBlocks.shimmerrockStairs, (ItemLike)ModBlocks.shimmerrock).m_176498_(consumer);
        this.slabShape((ItemLike)ModFluffBlocks.shimmerrockSlab, (ItemLike)ModBlocks.shimmerrock).m_176498_(consumer);
        this.stairs((ItemLike)ModFluffBlocks.shimmerwoodPlankStairs, (ItemLike)ModBlocks.shimmerwoodPlanks).m_176498_(consumer);
        this.slabShape((ItemLike)ModFluffBlocks.shimmerwoodPlankSlab, (ItemLike)ModBlocks.shimmerwoodPlanks).m_176498_(consumer);
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            this.registerForMetamorphic(consumer, variant);
        }
        Item[] pavementIngredients = new Item[]{Items.f_41852_, Items.f_42413_, Items.f_42534_, Items.f_42451_, Items.f_42405_, Items.f_42518_};
        for (int i2 = 0; i2 < pavementIngredients.length; ++i2) {
            this.registerForPavement(consumer, LibBlockNames.PAVEMENT_VARIANTS[i2], pavementIngredients[i2]);
        }
        this.wallShape((ItemLike)ModFluffBlocks.managlassPane, (ItemLike)ModBlocks.manaGlass, 16).m_176498_(consumer);
        this.wallShape((ItemLike)ModFluffBlocks.alfglassPane, (ItemLike)ModBlocks.elfGlass, 16).m_176498_(consumer);
        this.wallShape((ItemLike)ModFluffBlocks.bifrostPane, (ItemLike)ModBlocks.bifrostPerm, 16).m_176498_(consumer);
        List allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(ResourceLocationHelper::prefix).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_6612_(arg_0)).map(Optional::get).collect(Collectors.toList());
        for (int i3 = 0; i3 < allAzulejos.size(); ++i3) {
            int resultIndex = i3 + 1 == allAzulejos.size() ? 0 : i3 + 1;
            String recipeName = "azulejo_" + resultIndex;
            if (resultIndex == 0) {
                recipeName = recipeName + "_alt";
            }
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)allAzulejos.get(resultIndex))).m_126209_((ItemLike)allAzulejos.get(i3)).m_142284_("has_azulejo", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.azulejo0)).m_142409_("botania:azulejo_cycling").m_142700_(consumer, this.prefix(recipeName));
        }
        this.cosmeticBauble(consumer, (ItemLike)ModItems.blackBowtie, (ItemLike)ModItems.whitePetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.blackTie, (ItemLike)ModItems.orangePetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.redGlasses, (ItemLike)ModItems.magentaPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.puffyScarf, (ItemLike)ModItems.lightBluePetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.engineerGoggles, (ItemLike)ModItems.yellowPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.eyepatch, (ItemLike)ModItems.limePetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.wickedEyepatch, (ItemLike)ModItems.pinkPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.redRibbons, (ItemLike)ModItems.grayPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.pinkFlowerBud, (ItemLike)ModItems.lightGrayPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.polkaDottedBows, (ItemLike)ModItems.cyanPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.blueButterfly, (ItemLike)ModItems.purplePetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.catEars, (ItemLike)ModItems.bluePetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.witchPin, (ItemLike)ModItems.brownPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.devilTail, (ItemLike)ModItems.greenPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.kamuiEye, (ItemLike)ModItems.redPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.googlyEyes, (ItemLike)ModItems.blackPetal);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.fourLeafClover, (ItemLike)Items.f_42535_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.clockEye, (ItemLike)Items.f_42536_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.unicornHorn, (ItemLike)Items.f_42537_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.devilHorns, (ItemLike)Items.f_42538_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.hyperPlus, (ItemLike)Items.f_42539_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.botanistEmblem, (ItemLike)Items.f_42540_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.ancientMask, (ItemLike)Items.f_42489_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.eerieMask, (ItemLike)Items.f_42490_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.alienAntenna, (ItemLike)Items.f_42491_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.anaglyphGlasses, (ItemLike)Items.f_42492_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.orangeShades, (ItemLike)Items.f_42493_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.grouchoGlasses, (ItemLike)Items.f_42494_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.thickEyebrows, (ItemLike)Items.f_42495_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.lusitanicShield, (ItemLike)Items.f_42496_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.tinyPotatoMask, (ItemLike)Items.f_42497_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.questgiverMark, (ItemLike)Items.f_42498_);
        this.cosmeticBauble(consumer, (ItemLike)ModItems.thinkingHand, (ItemLike)ModBlocks.tinyPotato);
    }

    protected void registerSimpleArmorSet(Consumer<FinishedRecipe> consumer, Ingredient item, String variant, CriterionTriggerInstance criterion) {
        Item helmet = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_helmet")).get();
        Item chestplate = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_chestplate")).get();
        Item leggings = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_leggings")).get();
        Item boots = (Item)Registry.f_122827_.m_6612_(this.prefix(variant + "_boots")).get();
        ShapedRecipeBuilder.m_126116_((ItemLike)helmet).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)chestplate).m_126124_(Character.valueOf('S'), item).m_126130_("S S").m_126130_("SSS").m_126130_("SSS").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)leggings).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126130_("S S").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)boots).m_126124_(Character.valueOf('S'), item).m_126130_("S S").m_126130_("S S").m_142284_("has_item", criterion).m_176498_(consumer);
    }

    protected void registerToolSetRecipes(Consumer<FinishedRecipe> consumer, Ingredient item, Ingredient stick, CriterionTriggerInstance criterion, ItemLike sword, ItemLike pickaxe, ItemLike axe, ItemLike hoe, ItemLike shovel, ItemLike shears) {
        ShapedRecipeBuilder.m_126116_((ItemLike)pickaxe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SSS").m_126130_(" T ").m_126130_(" T ").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)shovel).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("S").m_126130_("T").m_126130_("T").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)axe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS").m_126130_("TS").m_126130_("T ").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)hoe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS").m_126130_(" T").m_126130_(" T").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)sword).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("S").m_126130_("S").m_126130_("T").m_142284_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)shears).m_126124_(Character.valueOf('S'), item).m_126130_("S ").m_126130_(" S").m_142284_("has_item", criterion).m_176498_(consumer);
    }

    protected void registerTerrasteelUpgradeRecipe(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike upgradedInput, ItemLike runeInput) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('T'), (ItemLike)ModItems.livingwoodTwig).m_206416_(Character.valueOf('S'), ModTags.Items.INGOTS_TERRASTEEL).m_126127_(Character.valueOf('R'), runeInput).m_126127_(Character.valueOf('A'), upgradedInput).m_126130_("TRT").m_126130_("SAS").m_126130_(" S ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(ModTags.Items.INGOTS_TERRASTEEL)).m_142284_("has_prev_tier", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(upgradedInput)).m_176498_(WrapperResult.ofType(ArmorUpgradeRecipe.SERIALIZER, consumer));
    }

    public static void registerRedStringBlock(Consumer<FinishedRecipe> consumer, ItemLike output, Ingredient input, CriterionTriggerInstance criterion) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('R'), (ItemLike)ModBlocks.livingrock).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.redString).m_126124_(Character.valueOf('M'), input).m_126130_("RRR").m_126130_("RMS").m_126130_("RRR").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.redString)).m_142284_("has_base_block", criterion).m_176498_(consumer);
    }

    protected void createFloatingFlowerRecipe(Consumer<FinishedRecipe> consumer, ItemLike input) {
        ResourceLocation inputName = Registry.f_122827_.m_7981_((Object)input.m_5456_());
        Item output = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(inputName.m_135827_(), "floating_" + inputName.m_135815_())).get();
        ShapelessRecipeBuilder.m_126189_((ItemLike)output).m_206419_(ModTags.Items.FLOATING_FLOWERS).m_126209_(input).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_176498_(consumer);
    }

    protected void deconstruct(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input, String name) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)output, (int)9).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(output)).m_126209_(input).m_142700_(consumer, this.prefix("conversions/" + name));
    }

    protected void deconstruct(Consumer<FinishedRecipe> consumer, ItemLike output, TagKey<Item> input, String name) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)output, (int)9).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(output)).m_206419_(input).m_142700_(consumer, this.prefix("conversions/" + name));
    }

    protected void deconstructPetalBlock(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)output, (int)9).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(output)).m_126209_(input).m_142409_("botania:petal_block_deconstruct").m_142700_(consumer, this.prefix("conversions/" + Registry.f_122827_.m_7981_((Object)input.m_5456_()).m_135815_() + "_deconstruct"));
    }

    protected void recombineSlab(Consumer<FinishedRecipe> consumer, ItemLike fullBlock, ItemLike slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)fullBlock).m_126127_(Character.valueOf('Q'), slab).m_126130_("Q").m_126130_("Q").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(fullBlock)).m_142700_(consumer, this.prefix("slab_recombine/" + Registry.f_122827_.m_7981_((Object)fullBlock.m_5456_()).m_135815_()));
    }

    protected void registerForQuartz(Consumer<FinishedRecipe> consumer, String variant, ItemLike baseItem) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix(variant)).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_slab")).get();
        Block stairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_stairs")).get();
        Block chiseled = (Block)Registry.f_122824_.m_6612_(this.prefix("chiseled_" + variant)).get();
        Block pillar = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_pillar")).get();
        ShapedRecipeBuilder.m_126116_((ItemLike)base).m_126127_(Character.valueOf('Q'), baseItem).m_126130_("QQ").m_126130_("QQ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(baseItem)).m_176498_(consumer);
        this.stairs((ItemLike)stairs, (ItemLike)base).m_176498_(consumer);
        this.slabShape((ItemLike)slab, (ItemLike)base).m_176498_(consumer);
        this.pillar((ItemLike)pillar, (ItemLike)base).m_176498_(consumer);
        this.chiseled((ItemLike)chiseled, (ItemLike)slab).m_142284_("has_base_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)base)).m_176498_(consumer);
    }

    protected void registerForWood(Consumer<FinishedRecipe> consumer, String variant) {
        TagKey<Item> tag = variant.contains("livingwood") ? ModTags.Items.LIVINGWOOD_LOGS : ModTags.Items.DREAMWOOD_LOGS;
        Block log = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_log")).orElseThrow();
        Block wood = (Block)Registry.f_122824_.m_6612_(this.prefix(variant)).orElseThrow();
        Block strippedLog = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_log")).orElseThrow();
        Block strippedWood = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant)).orElseThrow();
        Block glimmeringLog = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_" + variant + "_log")).orElseThrow();
        Block glimmeringWood = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_" + variant)).orElseThrow();
        Block glimmeringStrippedLog = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_stripped_" + variant + "_log")).orElseThrow();
        Block glimmeringStrippedWood = (Block)Registry.f_122824_.m_6612_(this.prefix("glimmering_stripped_" + variant)).orElseThrow();
        Block stairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_stairs")).orElseThrow();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_slab")).orElseThrow();
        Block wall = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_wall")).orElseThrow();
        Block strippedStairs = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_stairs")).orElseThrow();
        Block strippedSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_slab")).orElseThrow();
        Block strippedWall = (Block)Registry.f_122824_.m_6612_(this.prefix("stripped_" + variant + "_wall")).orElseThrow();
        Block planks = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_planks")).orElseThrow();
        Block planksStairs = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_planks_stairs")).orElseThrow();
        Block planksSlab = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_planks_slab")).orElseThrow();
        Block mossyPlanks = (Block)Registry.f_122824_.m_6612_(this.prefix("mossy_" + variant + "_planks")).orElseThrow();
        Block framed = (Block)Registry.f_122824_.m_6612_(this.prefix("framed_" + variant)).orElseThrow();
        Block patternFramed = (Block)Registry.f_122824_.m_6612_(this.prefix("pattern_framed_" + variant)).orElseThrow();
        Block fence = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_fence")).orElseThrow();
        Block fenceGate = (Block)Registry.f_122824_.m_6612_(this.prefix(variant + "_fence_gate")).orElseThrow();
        ShapelessRecipeBuilder.m_126191_((ItemLike)planks, (int)4).m_206419_(tag).m_142409_("planks").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(tag)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)wood, (int)3).m_142409_("wood").m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)log)).m_126127_(Character.valueOf('#'), (ItemLike)log).m_126130_("##").m_126130_("##").m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)strippedWood, (int)3).m_142409_("wood").m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)strippedLog)).m_126127_(Character.valueOf('#'), (ItemLike)strippedLog).m_126130_("##").m_126130_("##").m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringLog).m_142409_("botania:glimmering_" + variant).m_126209_((ItemLike)log).m_126209_((ItemLike)Items.f_42525_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)log)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringWood).m_142409_("botania:glimmering_" + variant).m_126209_((ItemLike)wood).m_126209_((ItemLike)Items.f_42525_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)wood)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringStrippedLog).m_142409_("botania:glimmering_" + variant).m_126209_((ItemLike)strippedLog).m_126209_((ItemLike)Items.f_42525_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)strippedLog)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)glimmeringStrippedWood).m_142409_("botania:glimmering_" + variant).m_126209_((ItemLike)strippedWood).m_126209_((ItemLike)Items.f_42525_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)strippedWood)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)glimmeringWood, (int)3).m_142409_("botania:glimmering_" + variant).m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)glimmeringLog)).m_126127_(Character.valueOf('#'), (ItemLike)glimmeringLog).m_126130_("##").m_126130_("##").m_142700_(consumer, this.prefix("glimmering_" + variant + "_from_log"));
        ShapedRecipeBuilder.m_126118_((ItemLike)glimmeringStrippedWood, (int)3).m_142409_("botania:glimmering_" + variant).m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)glimmeringStrippedLog)).m_126127_(Character.valueOf('#'), (ItemLike)glimmeringStrippedLog).m_126130_("##").m_126130_("##").m_142700_(consumer, this.prefix("glimmering_stripped_" + variant + "_from_log"));
        this.stairs((ItemLike)stairs, (ItemLike)wood).m_176498_(consumer);
        this.slabShape((ItemLike)slab, (ItemLike)wood).m_176498_(consumer);
        this.wallShape((ItemLike)wall, (ItemLike)wood, 6).m_176498_(consumer);
        this.fence((ItemLike)fence, (ItemLike)planks).m_176498_(consumer);
        this.fenceGate((ItemLike)fenceGate, (ItemLike)planks).m_176498_(consumer);
        this.stairs((ItemLike)strippedStairs, (ItemLike)strippedWood).m_176498_(consumer);
        this.slabShape((ItemLike)strippedSlab, (ItemLike)strippedWood).m_176498_(consumer);
        this.wallShape((ItemLike)strippedWall, (ItemLike)strippedWood, 6).m_176498_(consumer);
        this.stairs((ItemLike)planksStairs, (ItemLike)planks).m_176498_(consumer);
        this.slabShape((ItemLike)planksSlab, (ItemLike)planks).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)mossyPlanks).m_126209_((ItemLike)planks).m_126209_((ItemLike)Items.f_151016_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)planks)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)mossyPlanks).m_126209_((ItemLike)planks).m_126209_((ItemLike)Items.f_42029_).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)planks)).m_142700_(consumer, this.prefix("mossy_" + variant + "_planks_vine"));
        ShapedRecipeBuilder.m_126118_((ItemLike)framed, (int)4).m_126127_(Character.valueOf('W'), (ItemLike)planks).m_126130_("W W").m_126130_("W W").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)planks)).m_176498_(consumer);
        this.ringShape((ItemLike)patternFramed, (ItemLike)planks).m_176498_(consumer);
    }

    private void registerForPavement(Consumer<FinishedRecipe> consumer, String color, Item mainInput) {
        String baseName = color + "_pavement";
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix(baseName)).get();
        Block stair = (Block)Registry.f_122824_.m_6612_(this.prefix(baseName + "_stairs")).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix(baseName + "_slab")).get();
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_126191_((ItemLike)base, (int)3).m_126209_((ItemLike)ModBlocks.livingrock).m_126209_((ItemLike)Items.f_42594_).m_126209_((ItemLike)Items.f_41832_).m_142409_("botania:pavement").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModBlocks.livingrock));
        if (mainInput != Items.f_41852_) {
            builder.m_126209_((ItemLike)mainInput);
        }
        builder.m_176498_(consumer);
        this.slabShape((ItemLike)slab, (ItemLike)base).m_142409_("botania:pavement_slab").m_176498_(consumer);
        this.stairs((ItemLike)stair, (ItemLike)base).m_142409_("botania:pavement_stairs").m_176498_(consumer);
    }

    private void registerForMetamorphic(Consumer<FinishedRecipe> consumer, String variant) {
        Block base = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone")).get();
        Block slab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_slab")).get();
        Block stair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_stone_stairs")).get();
        Block brick = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks")).get();
        Block brickSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_slab")).get();
        Block brickStair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_stairs")).get();
        Block brickWall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_bricks_wall")).get();
        Block chiseledBrick = (Block)Registry.f_122824_.m_6612_(this.prefix("chiseled_metamorphic_" + variant + "_bricks")).get();
        Block cobble = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone")).get();
        Block cobbleSlab = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_slab")).get();
        Block cobbleStair = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_stairs")).get();
        Block cobbleWall = (Block)Registry.f_122824_.m_6612_(this.prefix("metamorphic_" + variant + "_cobblestone_wall")).get();
        InventoryChangeTrigger.TriggerInstance marimorphosis = RecipeProvider.conditionsFromItem((ItemLike)ModSubtiles.marimorphosis);
        this.slabShape((ItemLike)slab, (ItemLike)base).m_142409_("botania:metamorphic_stone_slab").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.stairs((ItemLike)stair, (ItemLike)base).m_142409_("botania:metamorphic_stone_stairs").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.brick((ItemLike)brick, (ItemLike)base).m_142409_("botania:metamorphic_brick").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.slabShape((ItemLike)brickSlab, (ItemLike)brick).m_142409_("botania:metamorphic_brick_slab").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.stairs((ItemLike)brickStair, (ItemLike)brick).m_142409_("botania:metamorphic_brick_stairs").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.wallShape((ItemLike)brickWall, (ItemLike)brick, 6).m_142409_("botania:metamorphic_brick_wall").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.brick((ItemLike)chiseledBrick, (ItemLike)brickSlab).m_142284_("has_base_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)brick)).m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.slabShape((ItemLike)cobbleSlab, (ItemLike)cobble).m_142409_("botania:metamorphic_cobble_slab").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.stairs((ItemLike)cobbleStair, (ItemLike)cobble).m_142409_("botania:metamorphic_cobble_stairs").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
        this.wallShape((ItemLike)cobbleWall, (ItemLike)cobble, 6).m_142409_("botania:metamorphic_cobble_wall").m_142284_("has_flower_item", (CriterionTriggerInstance)marimorphosis).m_176498_(consumer);
    }

    private ShapedRecipeBuilder compression(ItemLike output, TagKey<Item> input) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)output).m_206416_(Character.valueOf('I'), input).m_126130_("III").m_126130_("III").m_126130_("III").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromTag(input));
    }

    protected ShapedRecipeBuilder compression(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('I'), input).m_126130_("III").m_126130_("III").m_126130_("III").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input));
    }

    protected ShapedRecipeBuilder brick(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("QQ").m_126130_("QQ");
    }

    protected ShapedRecipeBuilder stairs(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("  Q").m_126130_(" QQ").m_126130_("QQQ");
    }

    protected ShapedRecipeBuilder slabShape(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)6).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("QQQ");
    }

    protected ShapedRecipeBuilder pillar(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)2).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("Q").m_126130_("Q");
    }

    protected ShapedRecipeBuilder chiseled(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)output).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('Q'), input).m_126130_("Q").m_126130_("Q");
    }

    protected ShapedRecipeBuilder wallShape(ItemLike output, ItemLike input, int amount) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)amount).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('B'), input).m_126130_("BBB").m_126130_("BBB");
    }

    protected ShapedRecipeBuilder fence(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)3).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("BSB").m_126130_("BSB");
    }

    protected ShapedRecipeBuilder fenceGate(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)3).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input)).m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("SBS").m_126130_("SBS");
    }

    protected ShapedRecipeBuilder ringShape(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126127_(Character.valueOf('W'), input).m_126130_(" W ").m_126130_("W W").m_126130_(" W ").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem(input));
    }

    protected void cosmeticBauble(Consumer<FinishedRecipe> consumer, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126127_(Character.valueOf('P'), input).m_126127_(Character.valueOf('S'), (ItemLike)ModItems.manaString).m_126130_("PPP").m_126130_("PSP").m_126130_("PPP").m_142409_("botania:cosmetic_bauble").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.conditionsFromItem((ItemLike)ModItems.manaString)).m_176498_(consumer);
    }

    protected void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        ResourceLocation name = Registry.f_122865_.m_7981_(serializer);
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, this.prefix("dynamic/" + name.m_135815_()).toString());
    }

    public String m_6055_() {
        return "Botania crafting recipes";
    }
}

